from django.conf import settings
from django.conf.urls.static import static
from django.urls import get_script_prefix
from django.contrib.staticfiles.views import serve
import sys
urlpatterns = []


def staticfiles_urlpatterns(prefix=None):
    """
    Helper function to return a URL pattern for serving static files.
    """
    if prefix is None:
        prefix = settings.STATIC_URL
    tmp_script_prefix = get_script_prefix()
    if len(tmp_script_prefix) > 1 and prefix.startswith(tmp_script_prefix):
        l1 = len(tmp_script_prefix)
        oldprefix = prefix
        prefix = prefix[l1:]        
    return static(prefix, view=serve)


# Only append if urlpatterns are empty
if settings.DEBUG and not urlpatterns:
    urlpatterns += staticfiles_urlpatterns()
