#!/usr/bin/env python

# Import things we need because we duplicated execute_manager
from django.core.management import stuff...

try:
    import settings # Assumed to be in the same directory.
except ImportError:
    import sys
    sys.stderr.write("Error: Can't find the file 'settings.py' in the directory containing %r. It appears you've customized things.\nYou'll have to run django-admin.py, passing it your settings module.\n(If the file settings.py does indeed exist, it's causing an ImportError somehow.)\n" % __file__)
    sys.exit(1)

# inline because this is dpaste
def twiddle(app):
    print 'Twiddle the frotz!'

def execute_manager(settings_mod, argv=None):
    project_directory = setup_environ(settings_mod)
    action_mapping = DEFAULT_ACTION_MAPPING.copy()

    # Remove the "startproject" command from the action_mapping, because that's
    # a django-admin.py command, not a manage.py command.
    del action_mapping['startproject']

    # Override the startapp handler so that it always uses the
    # project_directory, not the current working directory (which is default).
    action_mapping['startapp'] = lambda app_name, directory: startapp(app_name, project_directory)
    action_mapping['startapp'].__doc__ = startapp.__doc__
    action_mapping['startapp'].help_doc = startapp.help_doc
    action_mapping['startapp'].args = startapp.args

    # CUSTOM ACTION MAPPINGS
    action_mapping['twiddle'] = twiddle

    # Run the django-admin.py command.
    execute_from_command_line(action_mapping, argv)

if __name__ == "__main__":
    execute_manager(settings)
