# Generated by Django 4.2.6 on 2023-10-23 19:04

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.functions.text
import django.utils.timezone
import knowledgebase.models


class Migration(migrations.Migration):

    replaces = [('knowledgebase', '0001_initial'), ('knowledgebase', '0002_alter_stakeholder_name'), ('knowledgebase', '0003_document_author'), ('knowledgebase', '0004_stakeholder_documents'), ('knowledgebase', '0005_remove_document_author'), ('knowledgebase', '0006_alter_document_comments_alter_document_description_and_more'), ('knowledgebase', '0007_document_author'), ('knowledgebase', '0008_remove_stakeholder_documents'), ('knowledgebase', '0009_alter_document_options_alter_stakeholder_options_and_more'), ('knowledgebase', '0010_rename_author_document_authors'), ('knowledgebase', '0011_location_product_supply_stakeholdercategoty_and_more'), ('knowledgebase', '0012_rename_stakeholdercategoty_stakeholdercategory_and_more'), ('knowledgebase', '0013_alter_document_options_alter_impactcategory_parent_and_more'), ('knowledgebase', '0014_alter_impactcategory_description_and_more'), ('knowledgebase', '0015_alter_impactcategory_parent_and_more'), ('knowledgebase', '0016_alter_stakeholder_options_stakeholder_category_and_more'), ('knowledgebase', '0017_alter_document_options_alter_impact_options_and_more'), ('knowledgebase', '0018_location_within'), ('knowledgebase', '0019_remove_supply_location_remove_supply_product_and_more'), ('knowledgebase', '0020_rename_stakeholder_actor_and_more'), ('knowledgebase', '0021_alter_actor_options_alter_actorcategory_options_and_more'), ('knowledgebase', '0022_rename_impact_topic_and_more'), ('knowledgebase', '0023_evidence_rename_comments_document_note_and_more'), ('knowledgebase', '0024_impact_remove_topiccategory_parent_alter_actor_name_and_more'), ('knowledgebase', '0025_evidence_impact'), ('knowledgebase', '0026_alter_impact_options_remove_evidence_actor_and_more'), ('knowledgebase', '0027_alter_actor_slug_alter_document_slug_and_more'), ('knowledgebase', '0028_alter_actor_slug_alter_document_slug_and_more'), ('knowledgebase', '0029_remove_actor_slug_remove_document_slug_and_more'), ('knowledgebase', '0030_actor_slug_document_slug_evidence_slug_impact_slug_and_more'), ('knowledgebase', '0031_rename_slug_actor_slugg_rename_slug_document_slugg_and_more'), ('knowledgebase', '0032_remove_actor_slugg_remove_document_slugg_and_more'), ('knowledgebase', '0033_remove_document_topic'), ('knowledgebase', '0034_document_topic'), ('knowledgebase', '0035_alter_topic_actor_alter_topic_impact_and_more'), ('knowledgebase', '0036_actor_slug_document_slug_evidence_slug_impact_slug_and_more'), ('knowledgebase', '0037_remove_document_topic_document_topics'), ('knowledgebase', '0038_alter_document_topics'), ('knowledgebase', '0039_remove_evidence_slug'), ('knowledgebase', '0040_evidence_reference_evidence_relevance_and_more'), ('knowledgebase', '0041_remove_topic_impact_alter_actor_name_and_more'), ('knowledgebase', '0042_topic_impact'), ('knowledgebase', '0043_action_topic_action'), ('knowledgebase', '0044_document_todo_alter_document_description_and_more'), ('knowledgebase', '0045_actorcategory_slug_locationcategory_slug_and_more'), ('knowledgebase', '0046_document_created_at_document_updated_at'), ('knowledgebase', '0047_rename_action_activity_alter_activity_options_and_more'), ('knowledgebase', '0048_alter_evidence_options_evidence_slug_and_more'), ('knowledgebase', '0049_alter_actorcategory_slug_alter_locationcategory_slug_and_more'), ('knowledgebase', '0050_rename_topics_document_insights'), ('knowledgebase', '0051_rename_insights_document_topics'), ('knowledgebase', '0052_document_volume_evidence_period'), ('knowledgebase', '0053_document_file'), ('knowledgebase', '0054_alter_evidence_period'), ('knowledgebase', '0055_remove_evidence_period_alter_activity_slug_and_more'), ('knowledgebase', '0056_alter_evidence_document_alter_evidence_topic'), ('knowledgebase', '0057_alter_document_topics_alter_evidence_document_and_more'), ('knowledgebase', '0058_alter_activity_slug_alter_actor_slug_and_more'), ('knowledgebase', '0059_alter_activity_slug_alter_actor_slug_and_more'), ('knowledgebase', '0060_remove_actorcategory_parent_and_more'), ('knowledgebase', '0061_alter_document_file'), ('knowledgebase', '0062_alter_activity_slug_alter_actor_slug_and_more'), ('knowledgebase', '0063_remove_activity_slug_remove_actor_slug_and_more'), ('knowledgebase', '0064_alter_actor_name_alter_location_name'), ('knowledgebase', '0065_alter_document_subtitle_alter_document_title'), ('knowledgebase', '0066_location_parent'), ('knowledgebase', '0067_remove_location_within'), ('knowledgebase', '0068_alter_evidence_document_alter_evidence_topic'), ('knowledgebase', '0069_alter_evidence_document_alter_evidence_topic'), ('knowledgebase', '0070_alter_evidence_relevance'), ('knowledgebase', '0071_alter_evidence_document_alter_evidence_topic'), ('knowledgebase', '0072_alter_evidence_document_alter_evidence_topic'), ('knowledgebase', '0073_alter_evidence_options'), ('knowledgebase', '0074_product_parent'), ('knowledgebase', '0075_alter_evidence_relevance'), ('knowledgebase', '0076_alter_evidence_relevance'), ('knowledgebase', '0077_rename_authors_document_editors_document_author'), ('knowledgebase', '0078_alter_evidence_relevance'), ('knowledgebase', '0079_remove_document_editors_document_assocs'), ('knowledgebase', '0080_activity_parent_alter_document_assocs'), ('knowledgebase', '0081_actor_abbreviation_actor_alternative_names'), ('knowledgebase', '0082_alter_document_author_alter_document_volume'), ('knowledgebase', '0083_alter_activity_options_alter_impact_options_and_more'), ('knowledgebase', '0084_actor_parent'), ('knowledgebase', '0085_product_alternative_names_and_more'), ('knowledgebase', '0086_producttagtree_producttag_product_tags_and_more'), ('knowledgebase', '0087_rename_producttagtree_producttreetag'), ('knowledgebase', '0088_alter_product_tags_alter_product_tree_tags_and_more'), ('knowledgebase', '0089_alter_product_tags_alter_product_tree_tags_and_more'), ('knowledgebase', '0090_remove_product_tree_tags_and_more'), ('knowledgebase', '0091_remove_product_tags_remove_topic_product_tags_and_more'), ('knowledgebase', '0092_alter_topic_options_topic_products_and_more'), ('knowledgebase', '0093_alter_topic_product'), ('knowledgebase', '0094_topic_locations'), ('knowledgebase', '0095_topic_activities_topic_actors_topic_impacts'), ('knowledgebase', '0096_alter_topic_options_remove_topic_activity_and_more'), ('knowledgebase', '0097_alter_topic_activities_alter_topic_actors_and_more'), ('knowledgebase', '0098_product_members'), ('knowledgebase', '0099_remove_product_parent'), ('knowledgebase', '0100_category_product_cat'), ('knowledgebase', '0101_remove_product_cat_delete_category'), ('knowledgebase', '0102_location_members_alter_product_members'), ('knowledgebase', '0103_remove_location_parent_impact_members'), ('knowledgebase', '0104_activity_members_actor_members'), ('knowledgebase', '0105_remove_activity_parent_remove_actor_parent_and_more'), ('knowledgebase', '0106_topic_a2'), ('knowledgebase', '0107_remove_topic_a2_test'), ('knowledgebase', '0108_testa_alter_test_actors'), ('knowledgebase', '0109_alter_testa_options_testa_abbreviation_and_more'), ('knowledgebase', '0110_alter_testa_options'), ('knowledgebase', '0111_remove_testa_category_remove_testa_members_and_more'), ('knowledgebase', '0112_product_members2'), ('knowledgebase', '0113_alter_product_members2'), ('knowledgebase', '0114_remove_product_members2'), ('knowledgebase', '0115_alter_activity_options_alter_actor_options_and_more'), ('knowledgebase', '0116_impact_alternative_names_alter_document_assocs_and_more')]

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='ProductCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'abstract': False,
                'verbose_name': 'Product Category',
                'verbose_name_plural': 'Product Categories',
                'ordering': [django.db.models.functions.text.Lower('name')],
            },
        ),
        migrations.CreateModel(
            name='LocationCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'abstract': False,
                'verbose_name': 'Location Category',
                'verbose_name_plural': 'Location Categories',
                'ordering': [django.db.models.functions.text.Lower('name')],
            },
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.productcategory')),
                ('alternative_names', models.CharField(blank=True, max_length=250)),
                ('members', models.ManyToManyField(blank=True, related_name='memberships', to='knowledgebase.product')),
            ],
            options={
                'ordering': [django.db.models.functions.text.Lower('name')],
                'verbose_name': 'Product',
                'verbose_name_plural': 'Products',
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.locationcategory')),
                ('members', models.ManyToManyField(blank=True, related_name='memberships', to='knowledgebase.location')),
            ],
            options={
                'ordering': [django.db.models.functions.text.Lower('name')],
                'verbose_name': 'Location',
                'verbose_name_plural': 'Locations',
            },
        ),
        migrations.CreateModel(
            name='ActorCategory',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('description', models.TextField(blank=True)),
            ],
            options={
                'abstract': False,
                'verbose_name': 'Actor Category',
                'verbose_name_plural': 'Actor Categories',
                'ordering': [django.db.models.functions.text.Lower('name')],
            },
        ),
        migrations.CreateModel(
            name='Actor',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.stakeholdercategory')),
                ('abbreviation', models.CharField(blank=True, max_length=20)),
                ('alternative_names', models.CharField(blank=True, max_length=250)),
                ('members', models.ManyToManyField(blank=True, related_name='memberships', to='knowledgebase.actor')),
            ],
            options={
                'ordering': [django.db.models.functions.text.Lower('name')],
                'verbose_name': 'Actor',
                'verbose_name_plural': 'Actors',
            },
        ),
        migrations.CreateModel(
            name='Impact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('members', models.ManyToManyField(blank=True, related_name='memberships', to='knowledgebase.impact')),
                ('alternative_names', models.CharField(blank=True, max_length=250)),
            ],
            options={
                'verbose_name': 'Impact',
                'verbose_name_plural': 'Impacts',
                'ordering': [django.db.models.functions.text.Lower('name')],
            },
        ),
        migrations.CreateModel(
            name='Topic',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('actor', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.actor')),
                ('location', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.location')),
                ('product', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.product')),
                ('impact', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.impact')),
                ('activity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.action')),
                ('products', models.ManyToManyField(blank=True, related_name='products', to='knowledgebase.product')),
                ('locations', models.ManyToManyField(blank=True, related_name='locations', to='knowledgebase.location')),
            ],
            options={
                'verbose_name': 'Topic',
                'verbose_name_plural': 'Topics',
                'ordering': ['product', 'location', 'actor', 'impact', 'activity'],
            },
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250)),
                ('subtitle', models.CharField(blank=True, default='', max_length=250)),
                ('abstract', models.TextField(blank=True, default='')),
                ('note', models.TextField(blank=True, default='')),
                ('release_date', models.DateField(blank=True, null=True)),
                ('source', models.URLField(blank=True, null=True)),
                ('authors', models.ManyToManyField(blank=True, to='knowledgebase.stakeholder')),
                ('slug', models.SlugField()),
                ('todo', models.CharField(blank=True, max_length=250)),
                ('created_at', models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['release_date'],
                'verbose_name': 'Document',
                'verbose_name_plural': 'Documents',
            },
        ),
        migrations.CreateModel(
            name='Evidence',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.document')),
                ('topic', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.topic')),
                ('reference', models.CharField(blank=True, default='', help_text='Section, chapter, page or similar reference within the document', max_length=20)),
                ('relevance', models.CharField(blank=True, choices=[('H', 'High'), ('M', 'Useful'), ('L', 'Weak')], max_length=1)),
                ('slug', models.SlugField(default='slug-missing')),
            ],
            options={
                'verbose_name': 'Evidence',
                'verbose_name_plural': 'Evidences',
            },
        ),
        migrations.AddField(
            model_name='document',
            name='topics',
            field=models.ManyToManyField(blank=True, through='knowledgebase.Evidence', to='knowledgebase.topic'),
        ),
        migrations.AddField(
            model_name='document',
            name='file',
            field=models.FileField(blank=True, null=True, upload_to=knowledgebase.models.upload_file, validators=[django.core.validators.FileExtensionValidator(['pdf'])]),
        ),
        migrations.AlterField(
            model_name='document',
            name='note',
            field=models.TextField(blank=True, help_text='Just some notes fater reading the document'),
        ),
        migrations.RemoveField(
            model_name='document',
            name='slug',
        ),
        migrations.AlterField(
            model_name='document',
            name='todo',
            field=models.CharField(blank=True, help_text='Leftovers on tagging or reading this document', max_length=250),
        ),
        migrations.AddField(
            model_name='document',
            name='volume',
            field=knowledgebase.models.NoUpperCaseCharField(blank=True, help_text='Format-free reference to enclosing document', max_length=250),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='document',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='document_topics', to='knowledgebase.document'),
        ),
        migrations.RemoveField(
            model_name='evidence',
            name='slug',
        ),
        migrations.AlterField(
            model_name='evidence',
            name='topic',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='topic_documents', to='knowledgebase.topic'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='document',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.document'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='topic',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.topic'),
        ),
        migrations.AlterField(
            model_name='document',
            name='topics',
            field=models.ManyToManyField(blank=True, related_name='documents', through='knowledgebase.Evidence', to='knowledgebase.topic'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='document',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='document_topics', to='knowledgebase.document'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='topic',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='topic_documents', to='knowledgebase.topic'),
        ),
        migrations.AlterField(
            model_name='document',
            name='note',
            field=models.TextField(blank=True, help_text='Just some notes after reading the document'),
        ),
        migrations.AlterField(
            model_name='document',
            name='subtitle',
            field=knowledgebase.models.NoUpperCaseCharField(blank=True, max_length=250),
        ),
        migrations.AlterField(
            model_name='document',
            name='title',
            field=knowledgebase.models.NoUpperCaseCharField(max_length=250),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='document',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.document'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='topic',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, to='knowledgebase.topic'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='document',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='topics_evidence', to='knowledgebase.document'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='topic',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='documents_evidence', to='knowledgebase.topic'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='relevance',
            field=models.CharField(blank=True, choices=[('H', 'High'), ('M', 'Useful'), ('W', 'Weak')], max_length=1),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='document',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='evidence', to='knowledgebase.document'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='topic',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='evidence', to='knowledgebase.topic'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='document',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='evidences', to='knowledgebase.document'),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='topic',
            field=models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='evidences', to='knowledgebase.topic'),
        ),
        migrations.AlterModelOptions(
            name='evidence',
            options={'ordering': ['relevance'], 'verbose_name': 'Evidence', 'verbose_name_plural': 'Evidences'},
        ),
        migrations.AlterField(
            model_name='evidence',
            name='relevance',
            field=models.CharField(blank=True, choices=[('2', 'High'), ('5', 'Useful'), ('8', 'Weak')], max_length=1),
        ),
        migrations.AlterField(
            model_name='evidence',
            name='relevance',
            field=models.CharField(blank=True, choices=[(2, 'High'), (5, 'Useful'), (8, 'Weak')], max_length=1),
        ),
        migrations.RenameField(
            model_name='document',
            old_name='authors',
            new_name='editors',
        ),
        migrations.AlterField(
            model_name='evidence',
            name='relevance',
            field=models.CharField(blank=True, choices=[('2', 'High'), ('5', 'Useful'), ('8', 'Weak')], max_length=1),
        ),
        migrations.RemoveField(
            model_name='document',
            name='editors',
        ),
        migrations.AddField(
            model_name='document',
            name='assocs',
            field=models.ManyToManyField(blank=True, to='knowledgebase.actor', verbose_name='Association'),
        ),
        migrations.AddField(
            model_name='document',
            name='author',
            field=knowledgebase.models.NoUpperCaseCharField(blank=True, max_length=250, verbose_name='Author(s)'),
        ),
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('members', models.ManyToManyField(blank=True, related_name='memberships', to='knowledgebase.activity')),
                ('alternative_names', models.CharField(blank=True, max_length=250)),
            ],
            options={
                'verbose_name': 'Activity',
                'verbose_name_plural': 'Activities',
                'ordering': [django.db.models.functions.text.Lower('name')],
            },
        ),
        migrations.AddField(
            model_name='topic',
            name='activities',
            field=models.ManyToManyField(blank=True, related_name='activities', to='knowledgebase.activity'),
        ),
        migrations.AddField(
            model_name='topic',
            name='actors',
            field=models.ManyToManyField(blank=True, related_name='actors', to='knowledgebase.actor'),
        ),
        migrations.AddField(
            model_name='topic',
            name='impacts',
            field=models.ManyToManyField(blank=True, related_name='impacts', to='knowledgebase.impact'),
        ),
        migrations.AlterModelOptions(
            name='topic',
            options={'verbose_name': 'Topic', 'verbose_name_plural': 'Topics'},
        ),
        migrations.RemoveField(
            model_name='topic',
            name='activity',
        ),
        migrations.RemoveField(
            model_name='topic',
            name='actor',
        ),
        migrations.RemoveField(
            model_name='topic',
            name='impact',
        ),
        migrations.RemoveField(
            model_name='topic',
            name='location',
        ),
        migrations.RemoveField(
            model_name='topic',
            name='product',
        ),
        migrations.AlterField(
            model_name='topic',
            name='activities',
            field=models.ManyToManyField(blank=True, related_name='topics', to='knowledgebase.activity'),
        ),
        migrations.AlterField(
            model_name='topic',
            name='actors',
            field=models.ManyToManyField(blank=True, related_name='topics', to='knowledgebase.actor'),
        ),
        migrations.AlterField(
            model_name='topic',
            name='impacts',
            field=models.ManyToManyField(blank=True, related_name='topics', to='knowledgebase.impact'),
        ),
        migrations.AlterField(
            model_name='topic',
            name='locations',
            field=models.ManyToManyField(blank=True, related_name='topics', to='knowledgebase.location'),
        ),
        migrations.AlterField(
            model_name='topic',
            name='products',
            field=models.ManyToManyField(blank=True, related_name='topics', to='knowledgebase.product'),
        ),
        migrations.AlterModelOptions(
            name='evidence',
            options={'ordering': ['relevance', '-document__release_date'], 'verbose_name': 'Evidence', 'verbose_name_plural': 'Evidences'},
        ),
    ]
