"""
Tests for initial SQL insertion.
"""

from django.db import models

class Simple(models.Model):
    name = models.CharField(max_length = 50)

    def __unicode__(self):
        return self.name


__test__ = {'API_TESTS':"""
# Syncdb introduces these records from custom SQL.
>>> from django.conf import settings
>>> from django.core import management
>>> from django.db.models import get_app

# Error only occurs when adding the SQL query to the debug output
# so need to be in debug mode
>>> _debug_setting_old = settings.DEBUG
>>> settings.DEBUG = True

# Reset the database representation of this app in a way that will
# trigger initial SQL loading while in DEBUG mode
>>> management.reset(get_app('initial_sql'), interactive=False)

>>> Simple.objects.all()
[<Simple: John & Kathy>, <Simple: Miles O'Brien>, <Simple: "100%" of % are not placeholders>]

# Restore DEBUG setting
>>> settings.DEBUG = _debug_setting_old
"""}

