from django.core import template

class MediaURLPrefixNode(template.Node):
    def render(self, context):
        try:
            from django.conf.settings import MEDIA_URL
        except ImportError:
            return ''
        return MEDIA_URL

def media_url_prefix(parser, token):
    """
    {% media_url_prefix %}
    """
    return MediaURLPrefixNode()

template.register_tag('media_url_prefix', media_url_prefix)
