r"""

# uses the simple Article model from the "basic" tests
>>> from models import Article

>>> from datetime import datetime
>>> a = Article(id=None, headline='Area man programs in Python', pub_date=datetime(2005, 7, 28))
>>> a.save()

# try json/xml/python without the fields keyword arg..

>>> serializers.serialize("json", [a])
'[{"pk": "1", "model": "serializerfields3466.article", "fields": {"headline": "Area man programs in Python", "pub_date": "2005-07-28 00:00:00"}}]'

>>> serializers.serialize("xml", [a])
'<?xml version="1.0" encoding="utf-8"?>\n<django-objects version="1.0"><object pk="1" model="serializerfields3466.article"><field type="CharField" name="headline">Area man programs in Python</field><field type="DateTimeField" name="pub_date">2005-07-28 00:00:00</field></object></django-objects>'

>>> serializers.serialize("python", [a])
[{'pk': '1', 'model': 'serializerfields3466.article', 'fields': {'headline': 'Area man programs in Python', 'pub_date': datetime.datetime(2005, 7, 28, 0, 0)}}]


# now try with the keyword arg:

>>> serializers.serialize("json", [a], fields=['headline'])
'[{"pk": "1", "model": "serializerfields3466.article", "fields": {"headline": "Area man programs in Python"}}]'

>>> serializers.serialize("xml", [a], fields=['headline'])
'<?xml version="1.0" encoding="utf-8"?>\n<django-objects version="1.0"><object pk="1" model="serializerfields3466.article"><field type="CharField" name="headline">Area man programs in Python</field></object></django-objects>'

>>> serializers.serialize("python", [a], fields=['headline'])
[{'pk': '1', 'model': 'serializerfields3466.article', 'fields': {'headline': 'Area man programs in Python'}}]

"""
from django.core import serializers



if __name__ == "__main__":
    import doctest
    doctest.testmod()
