#!/usr/bin/env python

import sys
import psycopg2


for level in (0, 1, 2):
    connection = psycopg2.connect(sys.argv[1])
    connection.set_isolation_level(level)

    if level == 2:
        isolevel = 'READ COMMITTED'
    else:
        isolevel = 'SERIALIZABLE'

    print 'In isolation level: %d' % (level,)

    c = connection.cursor()
    c.execute('SHOW TRANSACTION ISOLATION LEVEL')
    print 'Original isolation level: %s' % (c.fetchone()[0],)

    c = connection.cursor()
    c.execute('SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL %s' % (isolevel,))
    c.execute('SHOW TRANSACTION ISOLATION LEVEL')
    print 'Set isolation level to: %s' % (c.fetchone()[0],)
    #connection.commit()
    
    c = connection.cursor()
    c.execute('SHOW TRANSACTION ISOLATION LEVEL')
    print 'Next cursor got isolation level: %s' % (c.fetchone()[0],)
    
    connection.close()