"""
Timezone converter for Django.  This  filter converts a datetime from UTC to
the specified timezone.  If the specified timezone is unknown the filter
fails silently and returns the original datetime.

Requires the Python-timezone library (pytz) from http://pytz.sourceforge.net/.
"""

from datetime import datetime
from pytz import timezone, utc
from django import template

register = template.Library ()

@register.filter
def astimezone (value, arg):

    try:
        tz = timezone (arg)
    except KeyError:
        return value

    value_utc = datetime (value.year, value.month, value.day,
                          value.hour, value.minute, value.second,
                          value.microsecond, utc)

    return value_utc.astimezone (tz)

