"""
Timezone converter for Django.  This filter converts a datetime to the
specified timezone.  If the specified timezone is unknown the filter
fails silently and returns the original datetime.

Requires the Python-timezone library (pytz) from http://pytz.sourceforge.net/.
"""

from datetime import datetime
from os import environ
from pytz import timezone, utc
from django import template

register = template.Library ()

@register.filter
def astimezone (value, arg):

    try:
        src_tz = timezone (environ['TZ'])
        dst_tz = timezone (arg)
    except KeyError:
        return value

    print environ['TZ'], value, arg

    tmp = datetime (value.year, value.month, value.day,
                    value.hour, value.minute, value.second,
                    value.microsecond, src_tz)

    return tmp.astimezone (dst_tz)

