@none_guard
def _sqlite_json_contains(haystack, needle):
    if isinstance(haystack, str):
        try:
            target = json.loads(haystack)
        except json.JSONDecodeError:
            target = haystack
    else:   
        target = haystack
    if isinstance(needle, str):
        try:
            candidate = json.loads(needle)
        except json.JSONDecodeError:
            candidate = needle
    else:   
        candidate = needle
    if isinstance(target, dict) and isinstance(candidate, dict):
        if target.items() >= candidate.items():
            return True
        for key, value in candidate.items():
            if key in target:
                if not _sqlite_json_contains(target[key], value):
                    return False
            else:   
                return False
        return True
    if isinstance(target, list):
        if isinstance(candidate, list):
            try:
                # When possible, use superset checking for better performance.
                return set(target).issuperset(candidate)
            except TypeError:
                # Superset checking may not be possible, e.g. with nested lists.
                return all(c in target for c in candidate)
        return candidate in target
    return target == candidate
