from django.db.models import (
    Avg,
    Count,
    IntegerField,
    OuterRef,
    Subquery,
    Q
)
from django.test import TestCase

from django.contrib.postgres.aggregates import ArrayAgg
from myapp.models import *

class MyTests(TestCase):

    def test_reproduce(self):
        book = Book.objects.create(name="book")
        fav = FavoriteBook.objects.create(book=book)
        label = Label.objects.create(name="label")
        review = Review.objects.create(book=book)
        review.labels.add(label)

        q = (
            Book.objects
            .annotate(
                labels=ArrayAgg(
                    "reviews__labels",
                    filter=Q(reviews__labels__isnull=False),
                    distinct=True,
                )
            )
            .annotate(
                fav_count=Subquery(
                    FavoriteBook.objects.filter(book=OuterRef("pk"))
                    .annotate(count=Count("id"))
                    .values("count")[:1],
                    output_field=IntegerField(),
                )
            )
        )

        list(q) # -> works
        list(q.values('fav_count')) # -> works
        list(q.values('labels')) # -> crash
        # list(q.values('id')) # -> crash
        # list(q.values('name')) # -> crash
