"""
    Extra Field Classes
"""

from fields import Field, ValidationError, gettext, EMPTY_VALUES
import datetime

### HumanDateTimeField ###
from parsedatetime import parsedatetime

#The constructor compiles a bunch of regexs, might as well do it only once.
parse_calendar = parsedatetime.Calendar()

def parse_date_time(string):
    tup, flag = parse_calendar.parse(string)
    if (flag == 0):     # The string could not be parsed
        raise ValueError, "Unable to parse date/time."
    if (flag == 1):     # This was just a date
        value = datetime.datetime(*(tup[:3])) 
    else:
        value = datetime.datetime(*(tup[:6]))
    return value

class HumanDateTimeField(Field):
    """
    Uses the parsedatetime library to clean the value thereby allowing
    many different date-formats, including human readable strings like,
    "tomorrow" and "thursday at 10 pm".
    
    parsedatetime library: http://cheeseshop.python.org/pypi/parsedatetime/
    """
    
    def clean(self, value):
        """
        Validates that the input can be converted to a datetime. Returns a Python
        datetime.datetime object.
        """
        
        Field.clean(self, value)
        if value in EMPTY_VALUES:
            return None
        if isinstance(value, datetime.datetime):
            return value
        if isinstance(value, datetime.date):
            return datetime.datetime(value.year, value.month, value.day)
        try:
            return parse_date_time(value)
        except ValueError:
            pass
        raise ValidationError(
            gettext(u'Enter a valid date/time, like "today", "next tuesday at 2 am", "2006-10-28", or "10/24/99"'))
