from django.db import models
from django.contrib import admin


# models

class Attribute(models.Model):
    name = models.CharField(max_length=100, primary_key=True)
    display_name = models.CharField(max_length=100, blank=True)


class AttributeValue(models.Model):
    attribute = models.ForeignKey(Attribute, on_delete=models.CASCADE, related_name='values')
    value = models.CharField (max_length=500, null=False)


# admin

class AttributeValueInlineAdmin(admin.TabularInline):
    model = AttributeValue
    extra = 0


class AttributeAdmin(admin.ModelAdmin):
    list_display = ['name', 'display_name']
    inlines = (AttributeValueInlineAdmin,)


admin.site.register(Attribute, AttributeAdmin)
admin.site.register(AttributeValue, AttributeValueAdmin)