# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.contrib.auth import get_user_model
from django.db.models.signals import post_migrate
from django.apps import AppConfig


def create_data(**kwargs):
    from .models import Plan, Project, Task, Status

    get_user_model().objects.create_superuser(
        'admin', 'admin@admin.com', 'admin'
    )

    statuses = []
    for i in xrange(10):
        statuses.append(
            Status.objects.create(title='status %s' % i)
        )
    plan = Plan.objects.create(title='plan')
    project = Project.objects.create(title='project')
    project.plans.add(plan)
    for i in xrange(10):
        Task.objects.create(
            title='task %s' % i,
            status=statuses[i],
            target=project,
        )


class AppConfig(AppConfig):
    name = 'app'

    def ready(self):
        post_migrate.connect(create_data, sender=self)
