from django.db import models


class ItemManager(models.Manager):
    def get_queryset(self):
        return super().get_queryset().annotate(
            rating_avg=models.Avg('review__rating')
        )


class Item(models.Model):
    name = models.CharField(max_length=10, default='')

    objects = ItemManager()

    class Meta:
        base_manager_name = 'objects'


class Review(models.Model):
    item = models.ForeignKey(Item)
    rating = models.PositiveSmallIntegerField(default=0)
