from django.contrib import admin

from myapp.models import Article, Blog


# Register your models here.
class ArticleInline(admin.StackedInline):
    model = Article
    extra = 2
    # will only prepopulate the ``slug`` field for the 2 ``extra`` forms
    # in the formset
    prepopulated_fields = {"slug": ("title",)}


class BlogAdmin(admin.ModelAdmin):
    inlines = (ArticleInline,)
    prepopulated_fields = {"slug": ("title",)}


admin.site.register(Blog, BlogAdmin)
