from django.http import HttpResponse
from django.db.models import Prefetch
from django.contrib.auth import get_user_model

from posts.models import Post
from profiles.models import UserProfile, University

from django.views.generic import View


class TestPrefetchBug(View):
    queryset = (
        Post.objects
        .prefetch_related(
            Prefetch(
                'author__profile', queryset=(
                    UserProfile.objects
                    .prefetch_related(
                        Prefetch('university', queryset=(
                            University.objects.all()
                        ))
                    )
                )
            )
        )
    )

    def get(self, request, *args, **kwargs):
        msg = []

        msg.append(
            self.queryset._prefetch_related_lookups[0]
            .queryset._prefetch_related_lookups[0].prefetch_to
        )

        msg.extend([
            '{} - {}'.format(
                post.content,
                post.author.profile.university.name)
            for post in self.queryset.all()
        ])

        msg.append(
            self.queryset._prefetch_related_lookups[0]
            .queryset._prefetch_related_lookups[0].prefetch_to
        )

        return HttpResponse('<br>'.join(msg))
