"""
>>> timesince(t, t)
u'0 minutes'
>>> timesince(p1, t)
u'1 minute'
>>> timesince(p2, t)
u'1 hour'
>>> timesince(p3, t)
u'1 day'
>>> timesince(p4, t)
u'1 month'
>>> timesince(p5, t)
u'1 year'

>>> timesince(t, p1)
u'0 minutes'
>>> timesince(t, p2)
u'0 minutes'
>>> timesince(t, p3)
u'0 minutes'
>>> timesince(t, p4)
u'0 minutes'
>>> timesince(t, p5)
u'0 minutes'
>>> timesince(p6, t)
u'2 days, 6 hours'

>>> timesince(f1, t)
u'0 minutes'
>>> timesince(f2, t)
u'0 minutes'
>>> timesince(f3, t)
u'0 minutes'
>>> timesince(f4, t)
u'0 minutes'
>>> timesince(f5, t)
u'0 minutes'

>>> timesince(t, f1)
u'1 minute'
>>> timesince(t, f2)
u'1 hour'
>>> timesince(t, f3)
u'1 day'
>>> timesince(t, f4)
u'1 month'
>>> timesince(t, f5)
u'1 year'
>>> timesince(t, f6)
u'2 days, 6 hours'
"""

import datetime
from django.utils.timesince import timesince

t = datetime.datetime(2007, 9, 14, 13, 46, 0)

# Times in the past
p1 = t.replace(minute=t.minute-1)
p2 = t.replace(hour=t.hour-1)
p3 = t.replace(day=t.day-1)
p4 = t.replace(month=t.month-1)
p5 = t.replace(year=t.year-1)
p6 = t.replace(day=t.day-2, hour=t.hour-6)

# Times in the future
f1 = t.replace(minute=t.minute+1)
f2 = t.replace(hour=t.hour+1)
f3 = t.replace(day=t.day+1)
f4 = t.replace(month=t.month+1)
f5 = t.replace(year=t.year+1)
f6 = t.replace(day=t.day+2, hour=t.hour+6)
