from django.http import HttpResponse, Http404
from django.template import loader
from django.contrib.sites.models import Site
from django.core import urlresolvers
from django.views.decorators.cache import cache_page

# NOTE: decorated views (such as by cache_page) do not work with
# urlresolvers.reverse. see http://code.djangoproject.com/ticket/2564

# Defaults to caching the sitemap for one day.
CACHE_TIME = 60 * 60 * 24

#@cache_page( CACHE_TIME )
def index( req, sitemaps ):
    current_site = Site.objects.get_current()
    sites = []
    for section in sitemaps.keys():
        sitemap_url = urlresolvers.reverse( 'django.contrib.sitemap.views.sitemap', kwargs={'section':section} )
        sites.append( 'http://%s%s' % (current_site.domain, sitemap_url) )
    xml = loader.render_to_string( 'sitemap_index.xml', {'sitemaps':sites} )
    return HttpResponse( xml, mimetype='application/xml' )

#@cache_page( CACHE_TIME )
def sitemap( req, sitemaps, section = None ):
    maps = []
    urls = []
    if section is not None:
        if not sitemaps.has_key(section):
            return Http404( "No sitemap available for section: '%s'" % section )
        maps.append( sitemaps[section] )
    else:
        maps = sitemaps.values()
    for site in maps:
        if callable(site):
            urls.extend( site().get_urls() )
        else:
            urls.extend( site.get_urls() )
    xml = loader.render_to_string( 'sitemap.xml', {'urlset':urls} )
    return HttpResponse( xml, mimetype='application/xml' )
