"""
reversed urllookup tag

Usage:
---
{% load urlhelpers %}
{% url_for 'main.views.index' "request.method" request.path foo ok= "bar" method=request.method sub=9 %}
---
The first parameter is the view the url will point to. 
For the second and following parameters you can use named parameters like foo=bar.
Parameters and named parameters will be evaluated. If it doesn't evaluate then the string is used. 
In the above example this means, assuming you use requestContext as your context, that
"request.method" => request.method
foo => foo
"bar" => bar
request.method => GET

I'd be nice to have a middleware that prepopulated the named paramaters if they have already been given for a certain view

If you copy/paste this code, be sure to remove references to logging, rclogging (request cycly logging if you wondered) is my homebrewn interface to python logging.
"""

from django.template import Library, Node, resolve_variable, TemplateSyntaxError
from django.core.urlresolvers import reverse_match
from django.db.models import get_model
from lib.rclogging import logger
import re

register = Library()


def find_url_for_view(view , *args , **kwargs):
     # url = reverse(view, *args , **kwargs )
     # logger.debug(args)
     # logger.debug(kwargs)
     
     match = reverse_match(view,  args = args ,  kwargs = kwargs)
     url = match.get_url()
     logger.debug(match.get_unmatched_kwargs(kwargs))
     logger.debug(match.get_default_args())
     # logger.debug(re.split(r"[/.]" , url))
     
     # now i want to append a query string
     # i want to use the unmatched kwargs for this
     query_string = "&amp;".join(["=".join([k, str(v)]) for k , v in match.get_unmatched_kwargs(kwargs).items()])
     logger.debug(query_string)
     if len(query_string) > 0:
         query_string = "?" + query_string
         
     return url + query_string

class ReversedUrlNode(Node):
    def __init__(self , view , *args , **kwargs):
        self.args = args
        self.kwargs = kwargs
        self.view = view
        
    def safe_resolve(self , var , context):
        try:
            outvar = resolve_variable(var , context)
        except:
            outvar = var
        logger.debug("%s = %s" % (var ,outvar) )
        return outvar
    
    def render(self , context):
        args = [self.safe_resolve(v , context) for v in self.args]
        kwargs = dict([(k, self.safe_resolve(v , context)) for k , v in self.kwargs.items()])
        view = self.safe_resolve(self.view , context)
        # try:
        url = find_url_for_view(view , *args , **kwargs)
        # except:
        #    logger.warn("reversed lookup did a booboo")
        #    url = "n/a"
        # url = find_url_for_view(self.view , *args , **kwargs)
        return url
    
@register.tag()
def url_for(parser , token):
    raw = re.sub(r'\s*=\s*' , "=" , token.contents)
    # logger.debug(raw)
    bits=raw.split()
    if len(bits) < 2:
        raise TemplateSyntaxError, "url_for need atleast one argument: url_for my.view"
    args = []
    kwargs = {}
    view = bits[1]
    for bit in bits[2:]:
        pos_is = bit.find("=")
        if pos_is == -1:
            args.append(bit)
        else:
            kwargs[bit[:pos_is]] = bit[1+pos_is:]
            # logger.debug("kwargs[%s] = %s" % (bit[:pos_is] , bit[1+pos_is:]))
        
    return ReversedUrlNode(view , *args , **kwargs)