from django.db import models

# Create your models here.
  
# ---------------------------------------------------------------------
# This reproduces the original report. The admin app show
# a traceback when you click in the 'Add Child' button.
class Parent(models.Model):
    name = models.CharField(maxlength=100)
    bestchild = models.ForeignKey("Child", null=True, related_name="favoured_by")
    class Meta:
        verbose_name_plural = "01. Parents"

    class Admin:
        pass

class Child(models.Model):
    """
    manipulator = Child.AddManipulator()
    """
    name = models.CharField(maxlength=100)
    parent = models.ForeignKey(Parent)
    class Meta:
        verbose_name_plural = "02. Childs"

    class Admin:
        pass

# ---------------------------------------------------------------------
# This seems to demonstrate that the problem isn't related to the
# forward FK declaration from Poll to Choice that uses the "Choice"
# string notation as the related model spcification.
# The admin traceback still exists but this time when you click in the
# 'Add Choice' button.
class Poll(models.Model):
    question = models.CharField(maxlength=200)
    choice = models.ForeignKey("Choice")
    class Meta:
        verbose_name_plural = "03. Polls"

    class Admin:
        pass

class Choice(models.Model):
    choice = models.CharField(maxlength=200)
    assigned_poll = models.ForeignKey(Poll, null=True, related_name="preset_choice")
    class Meta:
        verbose_name_plural = "04. Choices"

    class Admin:
        pass

# ---------------------------------------------------------------------
# This seems to demonstrate the problems isn't related to the null=True
# option. When it is used in both FK the 'Add book' button click still
# generates a traceback.
class Author(models.Model):
    name = models.CharField(maxlength=50)
    writting = models.ForeignKey("Book", null=True, related_name="probable_author")
    class Meta:
        verbose_name_plural = "05. Authors"

    class Admin:
        pass

class Book(models.Model):
    title = models.CharField(maxlength=255)
    author = models.ForeignKey(Author, null=True, related_name="preferred_work")
    class Meta:
        verbose_name_plural = "06. Books"

    class Admin:
        pass

# ---------------------------------------------------------------------
# FK attribute names changed to differ from their respective related
# model names, 'related_name' options dropped.
# No traceback when clicking the 'Add reported' nor the 'Add article'
# buttons.
class Reporter(models.Model):
    name = models.CharField(maxlength=50)
    art = models.ForeignKey("Article", null=True)
    class Meta:
        verbose_name_plural = "07. Reporters"

    class Admin:
        pass

class Article(models.Model):
    headline = models.CharField(maxlength=255)
    auth = models.ForeignKey(Reporter)
    class Meta:
        verbose_name_plural = "08. Articles"

    class Admin:
        pass

# ---------------------------------------------------------------------
# This seems to indicate the problem is related to the fact the
# FK name is equal to the related model name but in lowercase
# (something already hinted by bmurdock@gmail.com).
# Traceback when BOTH 'Add painter' and 'Add Painting' buttons are cli-
# cked.
class Painter(models.Model):
    name = models.CharField(maxlength=50)
    painting = models.ForeignKey("Painting", null=True, related_name="probable_author")
    class Meta:
        verbose_name_plural = "09. Painters"

    class Admin:
        pass

class Painting(models.Model):
    name = models.CharField(maxlength=255)
    painter = models.ForeignKey(Painter, related_name="best_priced_painting")
    class Meta:
        verbose_name_plural = "10. Paintings"

    class Admin:
        pass

# ---------------------------------------------------------------------
# Just to be sure it has nothing to do with something reported in #999
# No related_name options, use the related model name in plural as the
# FK attribute name.
# No tracebacks.
class Owner(models.Model):
    name = models.CharField(maxlength=50)
    pets = models.ForeignKey("Pet", null=True)
    class Meta:
        verbose_name_plural = "11. Owners"

    class Admin:
        pass

class Pet(models.Model):
    nick = models.CharField(maxlength=255)
    owners = models.ForeignKey(Owner)
    class Meta:
        verbose_name_plural = "12. Pets"

    class Admin:
        pass
