from django.db import models

class Year(models.Model):
    date = models.DateField(auto_now_add=True)

    def __unicode__(self):
        return unicode(self.date)

class Student(models.Model):
    year    = models.ForeignKey('Year')
    number  = models.PositiveIntegerField()
    courses = models.ManyToManyField('Course')

    def __unicode__(self):
        return unicode(self.number)

class Course(models.Model):
    year       = models.ForeignKey('Year')
    department = models.CharField(max_length=4)
    number     = models.PositiveIntegerField()

    def __unicode__(self):
        return u''.join([self.department,unicode(self.number)])
