# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import uuid
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0005_alter_user_last_login_null'),
    ]

    operations = [
        migrations.CreateModel(
            name='Person',
            fields=[
                ('password', models.CharField(verbose_name='password', max_length=128)),
                ('last_login', models.DateTimeField(blank=True, verbose_name='last login', null=True)),
                ('is_superuser', models.BooleanField(verbose_name='superuser status', help_text='Designates that this user has all permissions without explicitly assigning them.', default=False)),
                ('email', models.EmailField(unique=True, max_length=254)),
                ('id', models.UUIDField(editable=False, serialize=False, primary_key=True, max_length=32, default=uuid.uuid4)),
                ('first_name', models.CharField(max_length=35)),
                ('is_active', models.BooleanField(default=True)),
                ('is_staff', models.BooleanField(default=False)),
                ('last_name', models.CharField(max_length=35)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_query_name='user', to='auth.Group', verbose_name='groups', related_name='user_set')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_query_name='user', to='auth.Permission', verbose_name='user permissions', related_name='user_set')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.UUIDField(editable=False, serialize=False, primary_key=True, max_length=32, default=uuid.uuid4)),
                ('title', models.CharField(max_length=150)),
                ('author', models.ForeignKey(related_query_name='page', to=settings.AUTH_USER_MODEL, related_name='pages')),
            ],
        ),
        migrations.CreateModel(
            name='Site',
            fields=[
                ('id', models.UUIDField(editable=False, serialize=False, primary_key=True, max_length=32, default=uuid.uuid4)),
                ('title', models.CharField(max_length=150)),
                ('members', models.ManyToManyField(related_query_name='site', related_name='sites', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='page',
            name='site',
            field=models.ForeignKey(related_query_name='page', to='myapp.Site', related_name='pages'),
        ),
    ]
