import uuid

from ... import models

from django.contrib.auth import get_user_model
from django.core.management import base


class Command(base.BaseCommand):
    help = 'Creates test data.'
    
    def handle(self, *args, **options):
        self.stdout.write('Creating test data...', ending='')
        self.stdout.flush()
        
        UserModel = get_user_model()
        john = UserModel(email='john@lennon.com', first_name='John', last_name='Lennon')
        john.save()
        paul = UserModel(email='paul@mccartney.com', first_name='Paul', last_name='McCartney')
        paul.save()
        
        site = models.Site(title='All About The Beatles')
        # site = models.Site(id=uuid.UUID('e8324abb-eda2-4108-8712-97c6cdedbafc'), title='All About The Beatles')
        site.save()
        site.members.add(john, paul)
        
        home_page = models.Page(title='Home', author=john, site=site)
        home_page.save()
        about_page = models.Page(title='About', author=paul, site=site)
        about_page.save()
        
        self.stdout.write(self.style.MIGRATE_SUCCESS(' OK'))
