import django
import sys
from   django.core.servers.basehttp import ServerHandler

__all__          = ["CGI_Server_Handler"]

__version__      = "0.1".strip ()
sys_version      = sys.version.split () [0]
software_version = "CGI_Wrapper/%s Python/%s" % (__version__, sys_version)

class CGI_Server_Handler (ServerHandler) :
    """A simpuated CGI server"""

    origin_server           = False
    default_settings_module = "settings"
    server_software         = software_version
    status                  = "500"

    def __init__ (self, environ, * path) :
        sys.path.extend (path)
        key                  = "DJANGO_SETTINGS_MODULE"
        if key not in environ :
            environ [key]    = self.default_settings_module
        self.request_handler = self
        super (CGI_Server_Handler, self).__init__ \
            ( sys.stdin, sys.stdout, sys.stderr, environ
            , multithread  = False
            , multiprocess = False
            )
    # end def __init__

    def run (self, cls) :
        super (CGI_Server_Handler, self).run (cls ())
    # end def run

    def log_request (self, status, bytes) :
        pass ### for now, ignore it
    # end def log_request

# end class CGI_Server_Handler
