class Djazzify(object):
    """
    Adds a Django header to requests.
    """
    def process_response(self, request, response):
        # thought about including version info, but decided it was better not to leak this
        response['X-Djazzified-By'] = "Django"
        return response

class NowPlaying(object):
    """
    Adds a Now-Playing song from a list of Django songs.
    """
    def process_response(self, request, response):
        
        # do this here so that people only using Djazzify don't get this unnecessarily.
        from random import sample
        
        # list of tunes from http://www.djangomusic.com/item_music.asp?id=R+++329540&dt=2&cid=&sid=&mediatype=
        tunes = [ "St. Louis Blues", "After You've Gone"
            "Nagasaki", "Swing Guitars", "Exactly Like You", "Solitude", 
            "You're Driving Me Crazy", "Ain't Misbehavin'", "Rose Room",
            "Chicago", "Minor Swing", "Swingin' with Django", "Lambeth Walk",
            "Swing '39", "Japanese Sandman", "Nuages", ]

        response['X-Now-Playing'] = sample( tunes, 1 )[ 0 ]
        return response
