from __future__ import unicode_literals
from testproject.inspections.models import Inspector
from testproject.properties.models import Property
from django.db import models
from django.contrib.auth.models import User
from django.core.urlresolvers import reverse


class Round(models.Model):
    inspector = models.ForeignKey(Inspector, null=True, blank=True)
    chieftan = models.ForeignKey(User, null=True, blank=True)


class Task(models.Model):
    assigned_to = models.ForeignKey(User, blank=True, null=True, related_name='+')
    updated_by = models.ForeignKey(User, blank=True, null=True, editable=False, related_name='+')
    inspector = models.ForeignKey(Inspector, blank=True, null=True)
    round = models.ForeignKey(Round, blank=True, null=True, on_delete=models.SET_NULL)
    property = models.ForeignKey(Property)
