from django.db import models


class Bar(models.Model):
    name = models.CharField(unique=True, max_length=32)
    description = models.TextField(null=True, blank=True)
    parent = models.ForeignKey(
        "self",
        null=True,
        blank=True
    )


class SomeModel(models.Model):
    foo = models.ForeignKey(Bar)
    some_field = models.CharField(max_length=256)


class YetAnotherModel(models.Model):
    foo = models.ForeignKey(Bar)
    another_field = models.BooleanField(default=True)