# Create your views here.
from django.contrib.contenttypes.models import ContentType
from django.contrib.auth.models import User, Group, Permission
from django.shortcuts import render_to_response, get_object_or_404
from auth.rlp_manipulator import RLPManipulator
from django import forms

def editRowLvlPerm(request, obj_type, obj_id):
    ct = get_object_or_404(ContentType, model__exact=obj_type)
    obj = get_object_or_404(ct.model_class(), pk=obj_id)
    

    manip = RLPManipulator(obj, ct)
    
    if request.POST:
        new_data = request.POST.copy()
        
        errors = manip.get_validation_errors(new_data)

        if not errors:
            # No errors. This means we can save the data!
            manip.do_html2python(new_data)
            new_rlp = manip.save(new_data)

            return HttpResponseRedirect("/")
    else:
        # No POST, so we want a brand new form without any data or errors.
        errors = new_data = {}
    
    newForm = forms.FormWrapper(manip, new_data, errors)

    
    return render_to_response('editAuth/edit.html', {'newRLP':newForm, 'obj': obj,})