"""
This module contains helper functions for dealing with hash algorithms.
this was written to "uncouple" other modules from the actual algorithms used.
can be changed through the settings variable FAVORITE_HASH_ALGO.

currently used from the algorithms' interfaces:
 * hash.new("some string").hexdigest()
   returns a hexdigest for the given string, used in:
   * django/contrib/sessions/models.py
   * django/contrib/admin/views/decorators.py
 * hash.digest_size
   returns the digest_size (REMEMBER: hexdigest is twice as long), used in:
   * django/contrib/sessions/models.py
   * django/contrib/admin/views/decorators.py
"""
from django.conf import settings

DEFAULT_HASH_ALGO="md5"
KNOWN_HASH_ALGOS=["md5", "sha"]

def _verify_hash_algo(algo):
    """ TODO: the verification of the hash algos is _way_ too simple..
    """
    if not algo in KNOWN_HASH_ALGOS:
        algo = DEFAULT_HASH_ALGO
    return algo

# TODO: a global variable is not really the nicest way :(
_algo = _verify_hash_algo(settings.FAVORITE_HASH_ALGO)

if _algo == "md5":
    import md5 as hash
elif _algo == "sha":
    import sha as hash
