from django.db import models

class Poll(models.Model):
    question = models.CharField(maxlength=200, db_column='custom_col_name')

    def __str__(self):
        return self.question

    class Admin:
        pass

class Choice(models.Model):
    """
    # Create a couple of Poll instances
    >>> p1 = Poll.objects.create(question='What database do you use?')
    >>> p2 = Poll.objects.create(question='When will Django 1.0 be released?')
    >>> Poll.objects.all()
    [<Poll: What database do you use?>, <Poll: When will Django 1.0 be released?>]

    # Create Choice objects
    # First some related to the above Polls
    >>> c1 = Choice.objects.create(choice='Postgres', poll=p1)
    >>> c2 = Choice.objects.create(choice='Next week',  poll=p2)
    >>> c3 = Choice.objects.create(choice='In 2007 Q2', poll=p2)

    # A Choice instance not related to any Poll (don't
    # create this the poll FK hasn't the null=True option)
    #>>> c4 = Choice.objects.create(choice='An orphan choice')

    #>>> Choice.objects.all()
    #[<Choice: An orphan choice>, <Choice: Postgres>, <Choice: Next week>, <Choice: In 2007 Q2>]
    >>> Choice.objects.all()
    [<Choice: Postgres>, <Choice: Next week>, <Choice: In 2007 Q2>]

    # THIS WILL FAIL
    # Test order_by using the old workaround using the related table
    # name + '.' + the field name that has a db_column option.
    >>> Choice.objects.order_by('ticket2210_poll.question')
    [<Choice: Postgres>, <Choice: Next week>, <Choice: In 2007 Q2>]
    >>> Choice.objects.order_by('-ticket2210_poll.question')
    [<Choice: Next week>, <Choice: In 2007 Q2>, <Choice: Postgres>]
    """

    #poll = models.ForeignKey(Poll, null=True)
    poll = models.ForeignKey(Poll)
    choice = models.CharField(maxlength=200)

    def __str__(self):
        return self.choice

    class Meta:
        ordering = ('poll',)
        #ordering = ('choice',)

    class Admin:
        list_display = ('choice', 'poll')
