from django.db import models

class Poll(models.Model):
    question = models.CharField(maxlength=200, db_column='custom_col_name')

    def __str__(self):
        return self.question

    class Admin:
        pass

class Choice(models.Model):
    """
    # Create a couple of Poll instances
    >>> p1 = Poll.objects.create(question='What database do you use?')
    >>> p2 = Poll.objects.create(question='When will Django 1.0 be released?')
    >>> Poll.objects.all()
    [<Poll: What database do you use?>, <Poll: When will Django 1.0 be released?>]

    # Create Choice objects
    # First some related to the above Polls
    >>> c1 = Choice.objects.create(choice='Postgres', poll=p1)
    >>> c2 = Choice.objects.create(choice='Next week',  poll=p2)
    >>> c3 = Choice.objects.create(choice='In 2007 Q2', poll=p2)

    # A Choice instance not related to any Poll (don't
    # create this the poll FK hasn't the null=True option)
    #>>> c4 = Choice.objects.create(choice='An orphan choice')

    #>>> Choice.objects.all()
    #[<Choice: An orphan choice>, <Choice: Postgres>, <Choice: Next week>, <Choice: In 2007 Q2>]
    >>> Choice.objects.all()
    [<Choice: Postgres>, <Choice: Next week>, <Choice: In 2007 Q2>]

    # Test ordeirng but this time using the patch attached to ticket #2076
    # and the new notation for specifying ordering by a related model field.
    # There is no need to use table names here
    >>> Choice.objects.order_by('poll__question')
    [<Choice: Postgres>, <Choice: Next week>, <Choice: In 2007 Q2>]
    >>> Choice.objects.order_by('-poll__question')
    [<Choice: Next week>, <Choice: In 2007 Q2>, <Choice: Postgres>]
    """

    #poll = models.ForeignKey(Poll, null=True)
    poll = models.ForeignKey(Poll)
    choice = models.CharField(maxlength=200)

    def __str__(self):
        return self.choice

    class Meta:
        ordering = ('poll',)
        #ordering = ('choice',)

    class Admin:
        list_display = ('choice', 'poll')
