import json
from django.views.generic import TemplateView
from django.views.generic.edit import FormView
from django.views.generic.list import MultipleObjectMixin
from django.views.generic.list import ListView
from forms import PromoModelForm
from django.http import HttpResponse
from django.template import RequestContext
from models import ContestEntries, PromoCodes,EmailRecord,loguservisits, Customers
from django.core.mail import EmailMessage
from django.conf import settings
from django.template.loader import render_to_string
from django.contrib.localflavor.us.us_states import US_STATES
from django.shortcuts import render_to_response
from django.db import IntegrityError
from django.http import Http404
from django.utils.translation import ugettext as _
import datetime
import hashlib
from hashlib import md5
#from reportlab.pdfgen import canvas
from django.http import HttpResponse
from django.db import connection, transaction 
#import reportlab
import cx_Oracle
from django.db import transaction
from django.core import serializers


class IndexView(FormView, MultipleObjectMixin):  #A view that displays a form. On error, redisplays the form with validation errors; on success, redirects to a new URL.#
    template_name = "index.html"            #(A base view for displaying a list of objects. It is not intended to be used directly, but
    form_class = PromoModelForm
    success_url = ''
    model = ContestEntries
    
    
    def get(self, request, *args, **kwargs):

        self.object_list = self.get_queryset()
        allow_empty = self.get_allow_empty()
        if not allow_empty and len(self.object_list) == 0:
            raise Http404(_(u"Empty list and '%(class_name)s.allow_empty' is False.")
                          % {'class_name': self.__class__.__name__})
       
        form_class = self.get_form_class()
        form = self.get_form(form_class)
        context = self.get_context_data(object_list=self.object_list)
        context['form'] = form
        return self.render_to_response(context)
        
    def get_context_data(self, **kwargs):
        context = super(MultipleObjectMixin, self).get_context_data(**kwargs)
        context['states'] = self.request.GET.get('shop_state', '')
        context['email'] = self.request.GET.get('email', '')
        context['back_url'] = self.request.META.get('HTTP_REFERER', '/')
        context['website_url'] = 'http://' + self.request.META['HTTP_HOST']
        return context

    def post(self, request, *args, **kwargs):
        if request.is_ajax():
            entries = self.request.POST['model']
            entry = json.loads(entries)
            PROMOCODE = entry['PROMOCODE']
            attempt = entry['attempt']
            CUST_PERSONAL_EMAIL = entry['CUST_PERSONAL_EMAIL']
            CUST_FIRST_NAME = entry['CUST_FIRST_NAME']
            CUST_LAST_NAME = entry['CUST_LAST_NAME']
            CUST_TYPE_OF_BUSINESS = entry['CUST_TYPE_OF_BUSINESS']
            CUST_ADDRESS = entry['CUST_ADDRESS']
            CUST_CITY = entry['CUST_CITY']
            CUST_STATE = entry['CUST_STATE']
            CUST_POSTAL_CODE = entry['CUST_POSTAL_CODE']
            CUST_HOME_PHONE = entry['CUST_HOME_PHONE']
            value = entry['radio1']
            form_type = entry['form_type']
            attempt = attempt + 1
            error = {'attempt': attempt, 'status': 'error', 'form_type': 'simple'}
            moreinfo = {'attempt': attempt, 'status': 'moreinfo', 'form_type': 'extended', }
            success = {'attempt': attempt, 'status': 'success', 'form_type': 'simple', }
            fail = {'attempt': attempt, 'status': 'fail', 'form_type': 'simple'}
            form_success = {'attempt': attempt, 'status': 'form-success',
               'form_type': 'extended', 'PROMOCODE': self.default_promocode}

            try:
                ContestEntries.objects.get(promocode=PROMOCODE)
                ContestEntries.objects.filter(promocode=PROMOCODE).update(first_name=CUST_FIRST_NAME,last_name=CUST_LAST_NAME,shop_name=CUST_TYPE_OF_BUSINESS,
                shop_address=CUST_ADDRESS,shop_city=CUST_CITY,shop_state=CUST_STATE,shop_zip=CUST_POSTAL_CODE,phone=CUST_HOME_PHONE,email=CUST_PERSONAL_EMAIL,address=value,)
                return HttpResponse(json.dumps(form_success),
                mimetype='application/json')

            except:
                entry = ContestEntries(
                first_name=CUST_FIRST_NAME,
                last_name=CUST_LAST_NAME,
                shop_name=CUST_TYPE_OF_BUSINESS,
                shop_address=CUST_ADDRESS,
                email=CUST_PERSONAL_EMAIL,
                shop_city=CUST_CITY,
                shop_state=CUST_STATE,
                shop_zip=CUST_POSTAL_CODE,
                phone=CUST_HOME_PHONE,
                promocode=PROMOCODE,
                address=value,)
                self.send_confirmation_email(CUST_PERSONAL_EMAIL,
                                entry.confirmation_code)
                entry.save()
                return HttpResponse(json.dumps(form_success),
                mimetype='application/json')
           
        else:
            return render_to_response('error.html',
                context_instance=RequestContext(request))

    


"""
Displays the email confirmation page

"""


class ConfirmationView(ListView):
    template_name = "confirmation.html"
    model = ContestEntries
    
    
    def get(self, request, *args, **kwargs):
        self.object_list = self.get_queryset()
        allow_empty = self.get_allow_empty()
        if not allow_empty and len(self.object_list) == 0:
            raise Http404(_(u"Empty list and '%(class_name)s.allow_empty' is False.")
                          % {'class_name': self.__class__.__name__})

        context = self.get_context_data(object_list=self.object_list)
        context.update()
        return render_to_response('confirmation.html', context, context_instance=RequestContext(request))
        

    def get_context_data(self, **kwargs):
        context = super(ConfirmationView, self).get_context_data(**kwargs)
        email = self.request.GET.get('email', '')
        decodeemail = email.decode('base64') 
        code = self.request.GET.get('code', '')
        changecode = code.decode('base64')
        now = datetime.datetime.now()
        
        try:
            email_record = EmailRecord.objects.get(email=email)
        except:
            pass
        else:
            email_record.now_confirmed = True
            date_confirmed = str(now).split()
            email_record.date_confirmed = date_confirmed[0]
            email_record.save()

        try:
            entry = ContestEntries.objects.get(email=decodeemail,
                confirmation_code=changecode)
        except:
            context['result'] = 'error'
        else:
            entry.confirmed = True
            entry.save()
            context['result'] = 'confirmed'
        return context
        


class Registerview(FormView,ListView):
    template_name = "valid.html"
    model = Customers
    form_class = PromoModelForm
    
    def get(self, request, *args, **kwargs):
        week = Customers.objects.all()
        try:
            p=Customers.objects.get(PROMOCODE=request.GET['PROMOCODE'])
            wer=Customers.objects.filter(PROMOCODE=request.GET['PROMOCODE'])
            if request.method == 'POST': # If the form has been submitted...
                form = PromoModelForm(request.POST, request.FILES, instance=wer) # A form bound to the POST data
                if form.is_valid(): # All val
                    x = {'form': form, }
                raise Http404
        except Customers.DoesNotExist:
            raise Http404
        else:
            form = PromoModelForm(instance=p) # An unbound form
            x = RequestContext(request,{
            'week':week,
            'form':form
           })
        return render_to_response('valid.html',x, context_instance = RequestContext(request))    
            
        

    
    

class EmailView(TemplateView):
    template_name = "email_confirmation.html"
    