#!/usr/bin/env python
#vim:fileencoding=utf8

RESERVED = "!*'();:@&=+$,/?%#[]"
UNRESERVED = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_.~"
ALLOWED_CHARS = RESERVED + UNRESERVED

def escape(s):
    def escape_char(c):
        if c in ALLOWED_CHARS:
            return c
        else:
            return '%%%0x' % ord(c)
    return ''.join(escape_char(c) for c in s)

u = 'http://ru.wikipedia.org/Лопата'
print escape(u)
