from django.contrib import admin
from posts.models import *

class PostAdmin(admin.ModelAdmin):
    list_filter = ('genre',)
    search_fields = ['title']
    display_fields = ["title", "genre", "created"]

    def save_model(self, request, obj, form, change):
	if not change:
	    obj.author = request.user
	obj.save()
    
admin.site.register(Post, PostAdmin)