import base64, md5, random, sys, datetime
import cPickle as pickle
from django.db import models
from django.utils.translation import gettext_lazy as _
from django.conf import settings


class SessionLoaderBase:
    _type = 'memcache'
    #_type = None

    def __init__(self):
        if self._type == 'memcache':
            from memcache.models import SessionLoaderImpl
        else:
            from database.models import SessionLoaderImpl
        self._impl = SessionLoaderImpl()

    def get_new_session_key(self):
        "Returns session key that isn't being used."
        # The random module is seeded when this Apache child is created.
        # Use person_id and SECRET_KEY as added salt.
        while 1:
            session_key = md5.new(str(random.randint(0, sys.maxint - 1)) + str(random.randint(0, sys.maxint - 1)) + settings.SECRET_KEY).hexdigest()
            try:
                self.load(session_key=session_key)
            except SessionLoader.DoesNotExist:
                break
        return session_key

    def encode(self, session_dict):
        "Returns the given session dictionary pickled and encoded as a string."
        pickled = pickle.dumps(session_dict)
        pickled_md5 = md5.new(pickled + settings.SECRET_KEY).hexdigest()
        return base64.encodestring(pickled + pickled_md5)

    def decode(self, rawdata):
        encoded_data = base64.decodestring(rawdata)
        pickled, tamper_check = encoded_data[:-32], encoded_data[-32:]
        if md5.new(pickled + settings.SECRET_KEY).hexdigest() != tamper_check:
            from django.core.exceptions import SuspiciousOperation
            raise SuspiciousOperation, "User tampered with session cookie."
        try:
            return pickle.loads(pickled)
        # Unpickling can cause a variety of exceptions. If something happens,
        # just return an empty dictionary (an empty session).
        except:
            return {}

    def load(self, session_key):
        s = self._impl.load(session_key)
        if not s:
            raise SessionLoader.DoesNotExist
        return self.decode(s.session_data)

    def save(self, session_key, session_dict, expire_seconds):
        if session_dict:
            rawdata = self.encode(session_dict)
        else:
            rawdata = None
        return self._impl.save(session_key, rawdata, expire_seconds)

class SessionLoader:
    _loader = SessionLoaderBase()

    loader = classmethod(lambda cls: cls._loader)

    class DoesNotExist(Exception):
        pass
