from django.contrib import admin
from .models import Author, Book
 
class BookInline(admin.TabularInline):
    model = Book
    readonly_fields = ['slug']
 
class AuthorAdmin(admin.ModelAdmin):
    inlines = [BookInline]
 
admin.site.register(Author, AuthorAdmin)
admin.site.register(Book)