"""
This file demonstrates writing tests using the unittest module. These will pass
when you run "manage.py test".

Replace this with more appropriate tests for your application.
"""

from datetime import date
from django.test import TestCase
from models import Person

class Bug19881Test(TestCase):
    def setUp(self):
        # Create two men
        man1 = Person(first_name='SpongeBob', last_name='SquarePants', sex='M', birthday=date(2000, 1, 1))
        man1.save()

        man2 = Person(first_name='Peter', last_name='Pan', sex='M', birthday=date(1980, 12, 24))
        man2.save()
        
        # Create two women
        woman1 = Person(first_name='Lara', last_name='Croft', sex='F', birthday=date(2001, 1, 1))
        woman1.save()

        woman2 = Person(first_name='Marge', last_name='Simpson', sex='F', birthday=date(1985, 1, 3))
        woman2.save()
        
    def test_get_prev_man_by_birthday(self):
        man1 = Person.men.get(last_name='SquarePants')
        man2 = man1.get_previous_by_birthday()
        
        self.assertEqual(man2.sex, 'M')
        self.assertEqual(man2.last_name,'Pan')
		
	