from django.db import models

class Institution(models.Model):
    name = models.CharField(maxlength=200, core=True)
    reference_url = models.CharField(maxlength=200, core=True)
    class Admin:   # because of this field, no error here
        pass

    def __repr__(self):
        return self.name

class License(models.Model):
    # no Admin class will produce an error when added
    title = models.CharField(maxlength=200)
    reference_url = models.URLField()
    description = models.TextField()
    def __repr__(self):
        return self.title

class OperatingSystem(models.Model):
    # no Admin class: no way to add this object as a subpart of SoftwarePackage    
    name = models.CharField(maxlength=200, core=True)
    def __repr__(self):
        return self.name
    
class SoftwarePackage(models.Model):
    title = models.CharField(maxlength=200)
    institution = models.ForeignKey(Institution, null=True)
    license = models.ForeignKey(License, null=True)
    operating_system = models.ManyToManyField(OperatingSystem, null=True)
    open_source = models.BooleanField()

    def __repr__(self):
        return self.title
    class Admin:
        pass
    

