import os, glob, sys

rootpath = os.getcwd()
while True:
    files = [s for s in list(glob.glob("%s/*" % rootpath)) if s.endswith('settings.py')]
    print files
    if len(files) == 1:
        rootpath, site_name = os.path.split(rootpath)
        break
    rootpath = os.path.split(rootpath)[0]

rootpath = os.path.split(rootpath)[0]

sys.path.append(rootpath)

settings_module = '%s.settings' % site_name
os.environ['DJANGO_SETTINGS_MODULE'] = settings_module
__import__(settings_module)

def init_ramdb():
    # Change Settings
    from django.conf import settings
    settings.DATABASE_NAME = ':memory:'
    settings.DATABASE_ENGINE = 'sqlite3'
    
    # Reload DB module
    import django.db 
    import django.db.transaction

    # Make sure we kill the old connection
    del django.db.connection
    reload(django.db)

    # Force the transaction code to have a new connection
    django.db.transaction.connection = django.db.connection
    
    # Install Models
    from django.core import management
    from django.contrib.auth.management import create_superuser
    from django.dispatch import dispatcher
    from django.db.models import signals
    from django.contrib.auth import models as auth_app

    # We need to disconnect the create_superuser command
    receivers = dispatcher.getReceivers(sender=auth_app, \
                                        signal=signals.post_syncdb)

    # Receivers are a list of weak references, so we need to resolve those refs 
    # to strong references
    receivers = [r() for r in receivers]
    if create_superuser in receivers:
        dispatcher.disconnect(create_superuser, \
                                sender=auth_app, \
                                signal=signals.post_syncdb)
    management.syncdb()

init_ramdb()
