import sys, re
from urlparse import urlparse
from django.core.handlers.wsgi import WSGIRequest, WSGIHandler
from django.utils.encoding import force_unicode

class FixedWSGIRequest(WSGIRequest):
    def __init__(self, environ):
        super(FixedWSGIRequest, self).__init__(environ)
        if 'HTTP_REFERER' in self.META:
            parsed_url = urlparse(self.META['HTTP_REFERER'])
            if sys.version_info >= (2, 6):
                host = parsed_url.netloc
            else:
                host = parsed_url[1]
            domain = host.split(':')[0]
            if not re.match(r'^[a-zA-Z\d\-\.]+$', domain):
                punycode_domain = force_unicode(domain).encode('idna')
                self.META['HTTP_REFERER'] = self.META['HTTP_REFERER'].replace(domain, punycode_domain, 1)

class FixedWSGIHandler(WSGIHandler):
    request_class = FixedWSGIRequest
