#! /usr/bin/env python

__ident__ = "$Id: test_models.py 48 2006-07-04 17:07:37Z erob $"

# A really nice blog from Ian Maurer on unit testing django:
# http://itmaurer.com/blog/?feed=atom

from test.test_support import run_unittest, verbose

import os, os.path
import unittest

class TestCase(unittest.TestCase):
      def setUp(self):
          # Test fixture method
          try:
              # Must configure django settings first
              #settings.configure(default_settings=_settings, USE_I18N=True)
              os.environ['DJANGO_SETTINGS_MODULE'] = 'settings'
          except Exception, e:
              from traceback import print_exc
              tb = print_exc()
              print str(tb)
              raise e
          else:
              from django.conf import settings
              self.settings = settings or None
              
          # Load the App instance object.
          try:
              from notmm.models import Poll, Choice
          except Exception, e:
              from traceback import print_exc
              tb = print_exc()
              if verbose: print str(tb)
              raise e
          else:
              # this technique must be upgraded..
              self.app = Poll()
         
      def tearDown(self):
          # test closure method
          self.settings = None
          del self.app

      def test_app_settings(self):
          # put some code here
          settings = self.settings
          self.failIf(settings.DATABASE_ENGINE != "postgresql_psycopg2",
self.settings.DATABASE_ENGINE)

      def test_app_inheritance(self):
          from notmm.models import Poll
          from django.db import models
          self.failUnless(issubclass(Poll, models.Model))

      def test_app_label(self):
          from notmm.models import Poll
          self.assertEqual(Poll._meta.app_label, 'notmm')

      def test_app_save(self):
          # try the app.save() method (it must work as expected)
          from notmm.models import Poll
          new_poll = Poll()
          new_poll.question = "What is Rhizobium?"
          self.failUnless(new_poll.save(), "Expecting save() to work")

      def test_app_install(self):
          try:
              from django.core import management
              from django.db.models import loading
              from notmm.models import Poll
              pyobj = loading.get_app(Poll._meta.app_label)
              management.install(pyobj)
          except Exception, e:
              from traceback import print_exc
              tb = print_exc()
              print str(tb)
              raise e
              
      def test_get_apps(self):
          from django.db.models import loading
          output = loading.get_apps()
          if verbose: print output

      def test_get_models(self):
          from django.db.models import get_models
          app = self.app
          models = get_models()
          self.failIf(models == [], 'Expecting a list of valid models, got %s'
          % models)

      def test_get_sql_create(self):
          from django.core.management import get_sql_create
          app = self.app
          output = get_sql_create(app)
          if verbose: print output


def test_main():
    tests = [ TestCase ]
    run_unittest(*tests)

if __name__ == '__main__':
   test_main()

