CREATE OR REPLACE PACKAGE django_seq IS

  FUNCTION NEXTVAL RETURN NUMBER;
  FUNCTION CURRVAL RETURN NUMBER;
END django_seq;
/
CREATE OR REPLACE PACKAGE BODY django_seq IS

  last_val NUMBER;
  shard_no NUMBER;

  FUNCTION NEXTVAL RETURN NUMBER IS
  BEGIN
    SELECT to_number(to_char(mr_inne_seq.nextval) || lpad(shard_no, 4, '0')) ||
           ltrim(to_char(MOD(abs(hsecs), 1000000), '000000'))
      INTO last_val
      FROM sys.v_$timer;
    RETURN last_val;
  END;

  FUNCTION CURRVAL RETURN NUMBER IS
    no_current_value EXCEPTION;
    PRAGMA EXCEPTION_INIT(no_current_value, -8002);
  BEGIN
    IF (last_val IS NULL) THEN
      RAISE no_current_value;
    END IF;
    RETURN last_val;
  END CURRVAL;

BEGIN
  --- the code below can use database table lookup
  shard_no := 5;

END django_seq;
/
