from django.contrib import admin

from .models import Post

class PostAdmin(admin.ModelAdmin):
    prepopulated_fields = {'slug': ('title',)}

    fieldsets = (
        (None, {'fields': (('title', 'slug'), 'text')}),
        ('Publishing options', {'fields': (('public', 'author'),
                                    ('pub_date', 'last_updated'))})
    )

    list_display = ('title',)

    def save_model(self, request, obj, form, change):
        if not change and not form.cleaned_data.get('author'):
            obj.author = request.user
        obj.save()

    def get_form(self, request, obj=None, **kwargs):
        form = super(PostAdmin, self).get_form(request, obj, **kwargs)
        form.base_fields['author'].required = False
        return form

admin.site.register(Post, PostAdmin)
