Index: django/contrib/humanize/templatetags/humanize.py
===================================================================
--- django/contrib/humanize/templatetags/humanize.py	(revision 16180)
+++ django/contrib/humanize/templatetags/humanize.py	(working copy)
@@ -152,13 +152,9 @@
     elif delta.seconds == 0:
         return _(u'now')
     elif delta.seconds < 60:
-        return _(u'%s seconds ago' % (delta.seconds))
-    elif delta.seconds / 60 < 2:
-        return _(r'a minute ago')
+        return ungettext(u'%s seconds ago', u'%s seconds ago', delta.seconds)
     elif delta.seconds / 60 < 60:
-        return _(u'%s minutes ago' % (delta.seconds/60))
-    elif delta.seconds / 60 / 60 < 2:
-        return _(u'an hour ago')
+        return ungettext(u'a minute ago', u'%s minutes ago', delta.seconds/60)
     elif delta.seconds / 60 / 60 < 24:
-        return _(u'%s hours ago' % (delta.seconds/60/60))
+        return ungettext(u'an hour ago', u'%s hours ago', delta.seconds/60/60)
     return naturalday(value, arg)
