from django.test import TestCase, Client

import re

class LangTest(TestCase):
    def test_error_language(self):
        """
        This site is in Portuguese, so the error message must also be in Portuguese.
        """

        c = Client()
        response = c.get('/lang')
        regexp = re.compile(r'<ul class="errorlist"><li>(.*)</li></ul>')
        match = regexp.search(response.content)
        self.assertEqual(match.group(1), 'Este campo \xc3\xa9 obrigat\xc3\xb3rio.')

