# vim: set fileencoding=utf-8 :

from django.http import HttpResponse
from django.core.validators import URLValidator, ValidationError

def go(request):
    # @see http://www.rooftopsolutions.nl/blog/internationalized-domain-names-are-you-ready
    tests = (u'http://www.yahoo.com',
             u'http://yahoo.com',
             u'http://sãopaulo.com/',
             u'http://sãopaulo.com.br/',
             u'http://пример.испытание/',
             u'http://مثال.إختبار/',
             u'http://例子.测试/',
             u'http://例子.測試/',
             u'http://उदाहरण.परीक्षा/',
             u'http://例え.テスト/',
             u'http://مثال.آزمایشی/',
             u'http://실례.테스트/',
             u'http://العربية.idn.icann.org/')

    resp = u''

    vali = URLValidator()
    for t in tests:
        try:
            vali(t)
            resp += u'<li>%s OK</li>' % t
        except ValidationError:
            resp += u'<li style="color:red; font-weight:bold;">%s FAILED VALIDATION</li>' % t

    return HttpResponse(resp)

        
    
