from django.db import models
from django.contrib.auth.models import User


class QuerySetManager(models.Manager):
    """
    Simon Willison's QuerySetManager
    http://djangosnippets.org/snippets/734/

    Enables adding new QuerySet methods using a Model inner class.
    """

    def get_query_set(self):
        return self.model.QuerySet(self.model)

    def __getattr__(self, attr, *args):
        return getattr(self.get_query_set(), attr, *args)


class TestModel(models.Model):

    user = models.ForeignKey(User)
    string = models.CharField(max_length=64, null=True, blank=True)

    objects = QuerySetManager()

    class QuerySet(models.query.QuerySet):
        pass
