import unittest
from django.conf import settings
from django.test import client
from django.contrib.auth.models import User
from models import Employee, WorkHour
import datetime

class SubclassedAdminFilterTestCase(unittest.TestCase):
    def setUp(self): 
        self.client = client.Client()
        self.old_language_code = settings.LANGUAGE_CODE 
        user = User.objects.create_user('super', 'super@example.com', 'secret' )
        user.is_staff = True
        user.is_superuser = True
        user.save()
        
        result = self.client.login(username='super', password='secret') 
        self.assertEqual(result, True)
        
    def tearDown(self): 
        settings.LANGUAGE_CODE = self.old_language_code 
        
        
    def testFilterSubclassed(self):
        e1 = Employee.objects.create(name='Anonymous', gender=1, age=22, alive=True, code='123') 
        e2 = Employee.objects.create(name='Visitor', gender=2, age=19, alive=True, code='124') 
        WorkHour.objects.create(datum=datetime.datetime.now(), employee=e1) 
        WorkHour.objects.create(datum=datetime.datetime.now(), employee=e2) 
        response = self.client.get("/admin/t15032/workhour/") 
        self.assertEqual(response.status_code, 200) 
        #self.assertContains(response, 'employee__person_ptr__exact') 
        response = self.client.get("/admin/t15032/workhour/?employee__person_ptr__exact=%d" % e1.pk) 
        self.assertEqual(response.status_code, 200) 