Index: django/contrib/formtools/tests/__init__.py
===================================================================
--- django/contrib/formtools/tests/__init__.py	(revision 14393)
+++ django/contrib/formtools/tests/__init__.py	(working copy)
@@ -359,4 +359,26 @@
                 "hash_0": "7e9cea465f6a10a6fb47fcea65cb9a76350c9a5c",
                 "wizard_step": "1"}
         wizard(DummyRequest(POST=data))
+    
+    def test_14291(self):
+        """
+        Regression test for ticket #14291.
+        """
+        reached = [False]
+        that = self
 
+        class WizardWithProcessStep(WizardClass):
+            def done(self, request, form_list):
+                reached[0] = True
+                that.assertTrue(len(form_list) == 2)
+
+        wizard = WizardWithProcessStep([WizardPageOneForm,
+                                        WizardPageTwoForm])
+
+        data = {"0-field": "test",
+                "1-field": "test2",
+                "hash_0": "2fdbefd4c0cad51509478fbacddf8b13",
+                "wizard_step": "1"}
+        wizard(DummyRequest(POST=data))
+        self.assertTrue(reached[0])
+
